/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.jobs.actions;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class CheckForExecutingTriggerRequest
extends BaseNodesRequest<CheckForExecutingTriggerRequest> {
    private String schedulerName;
    private List<String> triggerKeys;

    public CheckForExecutingTriggerRequest(StreamInput in) throws IOException {
        super(in);
        this.schedulerName = in.readString();
        this.triggerKeys = in.readStringList();
    }

    public CheckForExecutingTriggerRequest(String schedulerName, List<String> triggerKeys) {
        super(new String[0]);
        this.schedulerName = schedulerName;
        this.triggerKeys = triggerKeys;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.schedulerName);
        out.writeStringCollection(this.triggerKeys);
    }

    public ActionRequestValidationException validate() {
        if (this.schedulerName == null || this.schedulerName.length() == 0) {
            return new ActionRequestValidationException();
        }
        return null;
    }

    public String getSchedulerName() {
        return this.schedulerName;
    }

    public void setSchedulerName(String schedulerName) {
        this.schedulerName = schedulerName;
    }

    public List<String> getTriggerKeys() {
        return this.triggerKeys;
    }

    public void setTriggerKeys(List<String> triggerKeys) {
        this.triggerKeys = triggerKeys;
    }
}

